# Data Structure

## 스택, 큐

<details>
  <summary> 스택이란 무엇인가요? </summary>
  
> 스택은 LIFO(Last In First Out)로 동작하는 자료구조이다. 들어간 데이터가 스택에 차곡차곡 쌓여있다가 들어간 반대 순서로 나온다. 비어있는 스택에서 원소를 추출하려고 할 때 stack underflow라고 하며, 스택이 넘치는 경우 stack overflow라고 한다.

</details>

<details>
  <summary> 스택의 장단점은 무엇이 있을까요? </summary>

 > 장점
구조가 단순해서 구현이 쉽다.
데이터 저장/읽기 속도가 빠르다.

> 단점:
데이터 최대 개수를 미리 정해야 한다.(배열 기반)
저장 공간 낭비 발생할 수 있다. (미리 최대 개수만큼 저장 공간 확보해야 함)(배열 기반)

 </details>

<details>
  <summary> 스택의 필요한 상황엔 무엇이 있을까요? </summary>

>  중간에 있는 값을 굳이 뽑아내지 않고, 마지막에 삽입한 데이터를 뽑아낼 상황에서 유용, 계산 중에 잠시 기억해야하는 임시적인 자료를 관리하는 용도
 예)웹 히스토리에서 돌아가기 기능, 스택을 이용한 재귀,CPU도 여러가지 정보를 저장하기 위해 스택을 사용,함수의 call stack
</details>


<details>
  <summary> 큐란 무엇인가요? </summary>

> 스택이랑 반대. 먼저들어간 데이터가 먼저 나오는 원통형 자료구조. FIFO이다.
</details>


<details>
  <summary> 큐의 어느 위치에서나 데이터를 삽입하고 빼낼 수 있나요? </summary> 

> 언어마다 구현되어있는게 다른데, 일반적으로는 top에서 삽입하고 front에서 빼내는 기능이 있다. 다만 파이썬같은 경우 deque로 구현이 되어있어서 각각 top과 front 모두에서 push와 pop이 가능하다.
</details>

<details>
  <summary> 큐가 활용되는 경우는 어떤 경우인가요? </summary>
  
  > 넣은 순서대로 자료를 꺼내가므로 순서대로 처리해야하는 자료를 임시적으로 저장하는 용도로 흔히 사용. 입력순서에 따라 실행되어야하는 경우엔 스택보다 큐를 사용. 웨이팅, 줄서기에 비유할 수 있다. 
  캐시, 프로세스 관리에 사용
</details>



<details>
  <summary> 스택과 큐의 시간복잡도는 어떻게 되나요? </summary>
 
  > 스택은 push, pop 모두 O(1), 큐는 Array를 사용하고 삭제시 데이터를 당겨야하는 부분이라면 O(N)이고, 연결리스트를 사용하면 O(1)이다.
</details>

<details>
  <summary> 다양한 종류의 큐?  </summary>
 
  > 원형큐가 있음. 뒷쪽이 비었으면 활용할 수 있어서 공간적인 측면에서 효율적이다.
덱, 양쪽에서 데이터의 입,출력이 모두 가능한 자료구조

</details>

<details>
  <summary> 우선순위 큐 </summary>

> 우선순위 큐의 각 요소는 값과 우선순위, 총 2개의 데이터를 가지고 있습니다.
일반적인 큐와는 달리 우선순위가 높은 요소일수록 먼저 삭제되는 특징을 가지고 있으며 우선순위가 같은 데이터일 경우 삽입순서를 따름.
삽입 및 삭제 시 우선순위에 따라 요소들을 정렬 해야하기 때문에 주로 힙(Heap)이라는 자료구조로 구현됨
</details>

<details>
  <summary> 힙의 장점을 이용해서 우선순위 큐를 구현한 것과 그렇지 않은것의 차이는 무엇인가요? </summary>
  
  > 힙을 이용해서 구현하면 삽입 삭제 연산에 필요한 시간복잡도는 O(logn)이고, 배열이나 연결리스트로 구현한 우선순위 큐는 O(N)의 시간복잡도를 갖는다.
</details>